<?php
/**
 * Functionality for the navigation tree
 */

declare(strict_types=1);

namespace PhpMyAdmin\Navigation\Nodes;

use PhpMyAdmin\Config;
use PhpMyAdmin\Navigation\NodeType;

use function __;
use function _pgettext;

/**
 * Represents a container for index nodes in the navigation tree
 */
class NodeIndexContainer extends Node
{
    public function __construct(Config $config)
    {
        parent::__construct($config, __('Indexes'), NodeType::Container);

        $this->icon = ['image' => 'b_index', 'title' => __('Indexes')];
        $this->links = [
            'text' => ['route' => '/table/structure', 'params' => ['db' => null, 'table' => null]],
            'icon' => ['route' => '/table/structure', 'params' => ['db' => null, 'table' => null]],
        ];
        $this->realName = 'indexes';

        $newLabel = _pgettext('Create new index', 'New');
        $new = $this->getInstanceForNewNode($newLabel, 'new_index italics');
        $new->icon = ['image' => 'b_index_add', 'title' => $newLabel];
        $new->links = [
            'text' => [
                'route' => '/table/indexes',
                'params' => ['create_index' => 1, 'added_fields' => 2, 'db' => null, 'table' => null],
            ],
            'icon' => [
                'route' => '/table/indexes',
                'params' => ['create_index' => 1, 'added_fields' => 2, 'db' => null, 'table' => null],
            ],
        ];
        $this->addChild($new);
    }
}
